clear all
clc
close all

%% Create Data

load AALabData

Y=Action;
Row=row;
features=FeaturesAct;
clear FeaturesMatrix

load AANewData
features=[features; FeaturesAct];
Y=[Y;modal'];
Row=[Row;row'];

clear modal row

load AAMTData

s=length(row);
act=zeros(s,1);
for i=1:s
    act(i)=modal{i}(1);
end
features=[features; FeaturesAct];

Y=[Y;act];
Row=[Row;row];


%% Pareto-Dominant NE

ind=[3,15,27];
FeatParetoDomNE=features(:,ind);

n=length(Y);
paretonepred=zeros(n,1);
for i=1:n
    if sum(FeatParetoDomNE(i,:))>0
        paretonepred(i)=find(FeatParetoDomNE(i,:));
    else
        paretonepred(i)=2;
    end       
end


%% Find Level-1(alpha) Prediction
alpha=0.41;
lev1R=zeros(1,n);
for i=1:n
    R=Row{i}.^alpha;
    sumR=sum(R,2);
    [~,lev1R(i)]=max(sumR);
end

pnerightlev1wrong=zeros(1,n);
for i=1:n
    if lev1R(i)~=Y(i) & paretonepred(i)==Y(i)
        pnerightlev1wrong(i)=1;
    end
end

%% Find Errors

pneerr=logical(paretonepred~=Y);
lev1err=logical(lev1R'~=Y);

err=double([pneerr lev1err]);

[n,~]=size(pneerr);
pnerightlev1wrong=zeros(1,n);
pnewronglev1right=zeros(1,n);
bothright=zeros(1,n);
bothwrong=zeros(1,n);
for i=1:n
    if err(i,1)==0 & err(i,2)==1
        pnerightlev1wrong(i)=1;
    elseif err(i,1)==1 & err(i,2)==0
        pnewronglev1right(i)=1;
    elseif err(i,1)==0 & err(i,2)==0
        bothright(i)=1;
    elseif err(i,1)==1 & err(i,2)==1
        bothwrong(i)=1;
    end
end

'Number of games where the pne is right and level 1 action is wrong' 
sum(pnerightlev1wrong)

'Number of games where the pne is wrong and level 1 action is right' 
sum(pnewronglev1right)

'Number of games where the pne is right and level 1 action is right' 
sum(bothright)

'Number of games where the pne is wrong and level 1 action is wrong' 
sum(bothwrong)